#pragma once

#include "BaseShader.h"

using namespace std;
using namespace DirectX;

//Shader used to apply a gaussian blur to a texture
class GaussianBlurShader : public BaseShader
{
	public:
		//Need to know dimensions of the screen to calculate texel size
		struct ScreenBufferType
		{
			XMFLOAT2 screenDimensions;
			XMFLOAT2 padding;
		};

		GaussianBlurShader(ID3D11Device* device, HWND hwnd);
		~GaussianBlurShader();

		void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &worldMatrix, const XMMATRIX &viewMatrix, const XMMATRIX &projectionMatrix, ID3D11ShaderResourceView* texture);

	private:
		void initShader(const wchar_t* vs, const wchar_t* ps);
		ID3D11Buffer* screenBuffer;
		ID3D11SamplerState* sampleState;
};
